#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Phase EngineMod01.fsh  by   mpcomplete
//https://www.shadertoy.com/view/XlfGDf
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//#define DEBUG 1
#define time (iTime*.9)

// 2D rotation matrix.
mat2 rotate(float angle)
{
    return mat2(
        vec2( cos(angle), sin(angle)),
        vec2(-sin(angle), cos(angle)));
}

// Transform a point on square to a circle.
vec2 mapSquare(in vec2 p)
{
    vec2 ap = abs(p);
    float r = max(ap.x, ap.y);
    float angle = atan(p.y, p.x);

    return r*vec2(cos(angle), sin(angle));
}

// Make a pattern of squares in a repeating grid.
vec2 dupSquares(in vec2 p)
{
    vec2 ap = abs(sin(p*6.));
    float r = max(ap.x, ap.y);
    float angle = atan(p.y, p.x);

    return r*vec2(cos(angle), sin(angle));
}

// Duplicate pattern in dupSquaresConcentric squares.
vec2 dupSquaresConcentric(in vec2 p)
{
    vec2 ap = abs(p);
    float r = max(ap.x, ap.y);
    float angle = atan(p.y, p.x);

    return sin(3.*r)*vec2(cos(angle), sin(angle));
}

// Duplicate pattern in a repeating grid.
vec2 dupGrid(in vec2 p)
{
    return abs(sin(p*4.));
}

float numPhases = 6.;
vec2 getTransform(in vec2 p, float t)
{
    int which = int(mod(t, numPhases));

    if (which == 0) {
        p = mapSquare(p);
        p = pow(vec2(.3), abs(p));
        p = rotate(time*.1)*p;
        p += .1*sin(time*.2);
        p = dupSquares(p);
        p -= .1*sin(time*.2);
        p = dupSquares(p);
    } else if (which == 1) {
        p = pow(abs(p), vec2(.5));
        p = mapSquare(p);
        p = pow(abs(p), vec2(3.));
        p += .1*sin(time*.2);
        p = dupSquares(p);
        p = rotate(time*.1)*p;
        p = dupGrid(p);
        p -= .1;
        p = rotate(time*.1)*p;
    } else if (which == 2) {
        p = mapSquare(p);
        p = dupGrid(p*.5);
        p += .2 + .1*sin(time*.2);
        p = dupSquares(p);
        p = rotate(time*.1)*p;
        p = dupSquares(p);
    } else if (which == 3) {
        p = mapSquare(p);
        p = dupGrid(p*.7);
        p = dupSquaresConcentric(p);
        p = rotate(time*.1)*p;
        p = dupSquares(p);
        p += .3*sin(time*.2);
        p = pow(abs(p), vec2(.5));
        p = dupSquares(p);
    } else if (which == 4) {
        p = pow(vec2(.3), abs(p));
        p = mapSquare(p);
        p = dupGrid(p);
        p = dupSquaresConcentric(p);
        p = rotate(time*.1)*p;
        p = dupSquares(p);
        p += .3*sin(time*.2);
        p = pow(abs(p), vec2(.5));
        p = dupSquares(p);
    } else if (which == 5) {
        p = pow(vec2(.3), abs(p));
        p = mapSquare(p);
        p = dupGrid(p);
        p = dupSquaresConcentric(p);
        p += .3*sin(time*.2);
        p = rotate(time*.1)*p;
        p = dupSquares(p);
        p = pow(abs(p), vec2(.5));
        p = dupSquares(p);
    }
#if 0  // REJECTS
    } else {
        p = mapSquare(p);
        p = dupSquares(p*.5);
        p = dupGrid(p);
        p = dupSquares(p*.5);
        p = rotate(time*.1)*p;
        p = dupSquares(p);

    }
#endif
    return p;
}

vec2 applyTransform(in vec2 p)
{
    float t = time*.05;
#ifdef DEBUG
    if (iMouse.z > .001) t = iMouse.x/iResolution.x * numPhases;
#endif
    float pct = smoothstep(0., 1., mod(t, 1.));
    return mix(getTransform(p, t), getTransform(p, t+1.), pct);
}

mat3 rotation(float angle, vec3 axis)
{
    vec3 a = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;

    return mat3(oc * a.x * a.x + c,        oc * a.x * a.y - a.z * s,  oc * a.z * a.x + a.y * s,
                oc * a.x * a.y + a.z * s,  oc * a.y * a.y + c,        oc * a.y * a.z - a.x * s,
                oc * a.z * a.x - a.y * s,  oc * a.y * a.z + a.x * s,  oc * a.z * a.z + c);
}

// Fuzzy unit circle.
float circle(in vec2 p)
{
    float r = length(p);
    float angle = atan(p.y, p.x);
    if (1.-r < 0.)
        return 0.;
    return step(r, 1.) * pow(1.-r, .5);
}

vec3 recolor(vec3 c)
{
    vec3 axis = vec3(0.454,0.725,0.372);
    c = rotation(2.0*length(axis)*sin(time), axis)*c;
    return c;
}

vec4 applyColor(vec2 p)
{
    float c1 = circle(p);
#if 0
    float c2 = circle(p*1.7);
    float c3 = circle(p*1.3);
#else
    float c2 = circle(p*1.7 + .25*vec2(sin(time*.6), cos(time*.4)));
    float c3 = circle(p*1.3 - .15*vec2(sin(time*.5), cos(time*.5)));
#endif
	return vec4(recolor(vec3(c1, c2, c3)), 1.0);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 p = -1.0 + 2.0 * fragCoord.xy / iResolution.xy;
    p.x *= iResolution.x/iResolution.y;
    p *= 1.3;

    p = applyTransform(p);
	fragColor = applyColor(p);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

